{TDice v1.0  -  Release Date : May 3,1997

This Code is Freeware, feel free to do anything with it.

TDice sometimes not work correct if my System runs with 256 Colors, it
works always correct with Hi- or Truecolor ! Bug in Code ? Bug in Delphi ?
Bug on my System ? Bug in my Brain ? :-)....I don't know !

Comments, Critics etc. to dhild@t-online.de}

unit Dice;

{$R Dice.Res}

interface

uses
  Windows, Classes, Graphics, Controls;

type
  TDice = class(TGraphicControl)
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
    procedure Paint; override;
  private
    { Private-Deklarationen }
    FValue:byte;
    bmp,mask,work:TBitmap;
    dice:string;
    procedure SetBounds(ALeft, ATop, AWidth, AHeight: Integer); override;
    procedure SetValue(Number:byte);
  protected
    { Protected-Deklarationen }
  public
    { Public-Deklarationen }
  published
    { Published-Deklarationen }
    property Value: byte read FValue write SetValue;
    property ShowHint;
    property OnClick;
    property OnDblClick;
    property OnMouseDown;
    property OnMouseMove;
    property OnMouseUp;
  end;

procedure Register;

implementation

procedure Register;
begin
  RegisterComponents('Games', [TDice]);
end;

constructor TDice.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  FValue:=1;
  bmp:=TBitmap.Create;
  mask:=TBitmap.Create;
  work:=TBitmap.Create;
  work.Height:=100;
  work.Width:=100;
  dice:='DICE1';
  bmp.LoadFromResourceName(Hinstance,dice);
  mask.LoadFromResourceName(Hinstance,'MASK');
end;

destructor TDice.Destroy;
begin
  bmp.Free;
  mask.Free;
  work.Free;
  inherited Destroy;
end;

procedure TDice.SetValue(Number:byte);
begin
  if (Number > 0) and (Number < 7) then
  begin
     FValue:=Number;
     case FValue of
     1: dice:='DICE1';
     2: dice:='DICE2';
     3: dice:='DICE3';
     4: dice:='DICE4';
     5: dice:='DICE5';
     6: dice:='DICE6';
     end;
     bmp.LoadFromResourceName(Hinstance,dice);
     Repaint;
  end;
end;

procedure TDice.Paint;
var
  WorkRect:TRect;
begin
  WorkRect:=Rect(0,0,100,100);
  with work.Canvas do
  begin
     CopyMode:=cmSrcCopy;  
     CopyRect(WorkRect,Canvas,WorkRect);
     CopyMode:=cmSrcAnd;
     CopyRect(WorkRect,mask.Canvas,WorkRect);
     CopyMode:=cmSrcPaint;
     CopyRect(WorkRect,bmp.Canvas,WorkRect);
  end;
  Canvas.Draw(0,0,work);
end;

procedure TDice.SetBounds(ALeft, ATop, AWidth, AHeight: Integer);
begin
  inherited SetBounds(ALeft, ATop, 100, 100);
end;

end.
 